#!/usr/bin/perl

require "./params.pl";

sub connect 
{
  ## Initalise TCP socket
  socket(SH, PF_INET, SOCK_STREAM, getprotobyname('tcp')) || die $!;

  my $sin = sockaddr_in ($Port,inet_aton($server));
  connect(SH,$sin) || die &connect;

  $hostname=`hostname`;
  @hosts = split( '\n', $hostname );

  $first = "NICK $Botnick\n\r";
  syswrite(SH, $first, length($first));
  $first = "USER $Botnick @hosts[0] @hosts[0] :$Botnick \n\r";
  syswrite(SH, $first, length($first));
  $first = "MODE $Botnick +w \n\r";
  syswrite(SH, $first, length($first));

  sleep(5);

  foreach $chan (@chans)
  {
    $first = "JOIN $chan\n\r";
    syswrite(SH, $first, length($first));
  }
}

sub pingreply 
{
  $string = $_[0];
  @per = split(':', $string, 2);
  $pier = $per[1];
  $hostname=`hostname`;
  @hosts = split( '\n', $hostname );
  $ret = "PONG @hosts[0]";
  print $red."$string\n".$yellow."$ret\n";
  &rawirc($ret);
}


sub reconnect {
  close SH;
  &connect;
  &poll;
}

sub poll {
  while (<SH>) 
  {
    $buffer = $_;
    $buffer =~ s/\n//g;
    $buffer =~ s/\r//g;

    $buffer =~ s/\n//g;
    $buffer =~ s/\r//g;
    print "$buffer\n";
    if ($buffer =~ /privmsg/i) 
    {
       &msghandler($buffer);
    } 
    else 
    {
      if (substr($buffer,0,4) =~ /ping/i) 
      {
        &pingreply($buffer);
      }
    }
  }
  &reconnect;
}

# sig handler

sub shutdown {
  print "SIGINT caught\n";
  print "Disconnecting from irc server...\n";
  $iout = "QUIT :$quitmsg";
  &rawirc($iout);
  close SH;
  exit;
}

1;


