<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<title><?php wp_title( '|', true, 'right' ); ?></title>
<meta charset="<?php bloginfo( 'charset' ); ?>"/>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>


<?php $fav = get_theme_mod('mansar_favicon');  if (!empty( $fav ) ) { ?>
 <link rel="Shortcut Icon" href="<?php  echo get_theme_mod('mansar_favicon') ?>" type="image/x-icon" /> <?php } ?>

		
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<nav id="main-nav" class="top-bar">
	    <div id="main-nav-wrap" class="header-container">
	    <!-- Main Menu --> 
    	<?php if ( has_nav_menu( 'main-menu' ) ) : ?>
		<div id="menu-icon" class="pos-1"></div><?php
		wp_nav_menu( array( 'theme_location' => 'main-menu', 'container' => '', 'menu_id' =>'main-menu', 'menu_class' => 'menu' ) ); 
		endif; ?>
		    
		</div>
		<div class="clr"></div>
	</nav>
	<header id="top-header">
	    <div class="header-container">
		
            <?php if(is_home()) echo '<h1>'; else echo '<h2>'; ?>
			   <?php if ( get_theme_mod( 'mansar_logo' ) ) : ?>
    
        <a href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'>
		<img src='<?php echo esc_url( get_theme_mod( 'mansar_logo' ) ); ?>' alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'></a>
              <?php else : ?>
			
            <a title="Mansar" href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo" ><?php bloginfo( 'name' ); ?></a>
			<?php endif; ?>
			<?php if(is_home()) echo '</h1>'; else echo '</h2>'; ?>
       	    <div class="search-block">
	            <form method="get" id="searchform" class="clr" action="<?php echo home_url(); ?>/">
                    <input class="search-button" type="submit" value="Search">
					<input type="text" id="s" name="s" value="Search Here..." onfocus="if (this.value == 'Search Here...') {this.value = ''; }" onblur="if (this.value == '') {this.value = 'Search Here...';}">
			    </form>
		    </div>
            
            <div class="clr"></div>
        </div> <!-- end #header-container -->
	</header> <!-- end header -->
	
	
	<div class="container mtop">
		<div id="inner-content">