<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package PIKSEL18
 */

?>





<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

<script type="text/javascript" src="/scripts/updatepage.js"></script>

<div class="page-about">
  <div class="left-side">

<header class="entry-header">
		<?php
			if ( is_single() ) {
				the_title( '<h1 class="entry-title">', '</h1>' );
			} else {
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}

		if ( 'post' === get_post_type() ) : ?>
		<?php get_template_part( 'components/post/content', 'meta' ); ?>
		<?php
		endif; ?>
	</header>

		<? the_excerpt() ; ?>
	

<button class="trigger">Info</button>
  </div>

	<?php if ( '' != get_the_post_thumbnail() ) : ?>
		<div class="profile-photo">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'piksel18-featured-image' ); ?>
			</a>
		
	<?php endif; ?>

  </div>

<div class="right-side-info">
	
<div class="entry-content">

		<div class="entry-content">
		
<?php the_content( $more_link_text , $strip_teaser );
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'piksel18' ),
				'after'  => '</div>',
			) );
		?>
	</div>
	<?php get_template_part( 'components/post/content', 'footer' ); ?>
	</div></div>
</article><!-- #post-## -->
