<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package eco-lib-rebel
 */

?>
<div class="container">
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( '<img class="post-thumbnail">' != get_the_post_thumbnail() ) : ?>
		<div class="post-thumbnail">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'ecolibrebel-featured-image' ); ?>
			</a>
		</div>
	<?php endif; ?>
<div class="overlay"><div class="text">

		<header class="entry-header"><?php
			if ( is_single() ) {
				the_title( '<h1 class="entry-title">', '</h1>' );
			} else {
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}

		if ( 'post' === get_post_type() ) : ?>
		
		<?php
		endif; ?>
	</header>
	<div class="entry-content">
		<? the_excerpt( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'ecolibrebel' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ecolibrebel' ),
				'after'  => '</div>',
			) ); ?>

								

		</div>
	</div></div>
	
</article></div><!-- #post-## -->
