<?php
/*
  RBT : CUSTOM POST TYPE
*/
class RBT_Shortcode_CusotmPostType {
	
	public function __construct()
	{
		$this->register_post_type();
	}

	public function register_post_type()
	{
		$args = array();

		// RBT Shortcode
		$args['post-type-shortcode'] = array(
			'labels' => array(
				'name' => __( 'RBT Shortcode', 'rbt' ),
				'singular_name' => __( 'RBT Shortcode', 'rbt' ),
				'all_items' => 'RBT Shortcode',
				'add_new' => __( 'Add New', 'rbt' ),
				'add_new_item' => __( 'Add New RBT Shortcode', 'rbt' ),
				'edit_item' => __( 'Edit RBT Shortcode', 'rbt' ),
				'new_item' => __( 'New RBT Shortcode', 'rbt' ),
				'view_item' => __( 'View RBT Shortcode', 'rbt' ),
				'search_items' => __( 'Search Through RBT Shortcode Items', 'rbt' ),
				'not_found' => __( 'No shortcodes found', 'rbt' ),
				'not_found_in_trash' => __( 'No shortcodes found in Trash', 'rbt' ),
				'parent_item_colon' => __( 'Parent RBT Shortcode :', 'rbt' ),
				'menu_name' => __( 'RBT Shortcode', 'rbt' ),
			),	
				'public' => false,  
				'publicly_queriable' => true,  
				'show_ui' => true, 
				'exclude_from_search' => true,  
				'show_in_nav_menus' => false, 
				'has_archive' => false, 
				'rewrite' => false, 
				'hierarchical' => false,
				'can_export' => false,
				'menu_position' => 20,
				'description' => __( 'Add a Shortcode item', 'rbt' ),
				'supports' => array( 'title'),
				'menu_icon' =>  'dashicons-filter',
			);

		register_post_type('rbt-scode', $args['post-type-shortcode']);
	}
}

function rbt_init_shortcodecpt() { new RBT_Shortcode_CusotmPostType(); }
add_action( 'init', 'rbt_init_shortcodecpt' );

#-----------------------------------------------------------------#
# SORTABLE (ID) COLUMN
#-----------------------------------------------------------------#

add_filter('manage_edit-rbt-scode_columns', 'rbt_register_rbtscode_columns');
function rbt_register_rbtscode_columns($columns){

	$new_columns = array(
		'cb'     => '<input type="checkbox" />',
		'title'  => 'Name',
		'_rbt_shcode' => 'Shortcode'
	);
	return array_merge($new_columns,$columns);
}

add_action('manage_posts_custom_column', 'rbt_handle_rbtscode_columns', 10, 2 );

function rbt_handle_rbtscode_columns( $column ){

	global $post;
	if( $post->post_type != 'rbt-scode' ) return;	
	elseif( $column == '_rbt_shcode' ){
		$_rbt_shcode = get_post_meta( $post->ID, '_rbt_shcode', true );
		echo "<input type='text' class='rbt-textsc' onClick='this.select();' value='$_rbt_shcode' readonly='readonly'>";
	}
}

#-----------------------------------------------------------------#
# FETCH ALL REGISTRED IMAGE SIZES
#-----------------------------------------------------------------#

function rbt_image_sizes( $name, $value )
{
	global $_wp_additional_image_sizes;

	$sizes = array();

	foreach ( get_intermediate_image_sizes() as $_size ) {
		if ( in_array( $_size, array('thumbnail', 'medium', 'medium_large', 'large') ) ) {

			$width 		= get_option( "{$_size}_size_w" );
			$height 	= get_option( "{$_size}_size_h" );
			$crop 		= (bool) get_option( "{$_size}_crop" ) ? 'hard' : 'soft';

			$sizes[$_size]   = "{$_size} - {$width}x{$height}";

		} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {

			$width 		= $_wp_additional_image_sizes[ $_size ]['width'];
			$height 	= $_wp_additional_image_sizes[ $_size ]['height'];
			$crop 		= $_wp_additional_image_sizes[ $_size ]['crop'] ? 'hard' : 'soft';

			$sizes[$_size]   = "{$_size} - {$width}x{$height}";
		}
	}

	$sizes = array_merge($sizes, array('full' => 'original uploaded image'));

	$table = sprintf('<select name="%1$s" class="regular-text select2">', $name );
	foreach( $sizes as $key => $option ){
		$selected = ( $value == $key ) ? ' selected="selected"' : '';
		$table .= sprintf('<option value="%1$s" %3$s>%2$s</option>',$key, $option, $selected);
	}
	$table .= '</select>';

	return $table;
}

#-----------------------------------------------------------------#
# RBT METABOXES & META FIELDS
#-----------------------------------------------------------------#

add_action( 'add_meta_boxes', 'rbt_add_scodeopts_metabox' );
add_action( 'add_meta_boxes', 'rbt_add_settings_metabox' );
add_action( 'add_meta_boxes', 'rbt_add_right_side_custom_metabox' );
add_action( 'save_post', 'rbt_save_meta_fields' );

function rbt_add_scodeopts_metabox() {
    add_meta_box('rbt_metabox', __( 'Post Settings', 'rbt' ),'rbt_scopts_meta_fields','rbt-scode','normal','default');
}

function rbt_add_settings_metabox() {
    add_meta_box('rbt_set_metabox', __( 'Appearance Settings', 'rbt' ),'rbt_settings_meta_fields','rbt-scode','normal','default');
}

function rbt_add_right_side_custom_metabox() {
    add_meta_box('rbt_rs_metabox', __( 'Shortcode', 'rbt' ),'rbt_scode_meta_field','rbt-scode','side','default');
}

// Create Meta Fields Function
function rbt_scopts_meta_fields( $post ) 
{
	wp_nonce_field( plugin_basename( __FILE__ ), 'rbt_noncename' );
	$_rbt_selpost  = get_post_meta( $post->ID, '_rbt_selpost', true );
	$_rbt_seltax   = get_post_meta( $post->ID, '_rbt_seltax', true );
	$_rbt_taxterms = get_post_meta( $post->ID, '_rbt_taxterms', true );
	
	// Sanitiz the meta fields
	$_rbt_selpost  = !empty($_rbt_selpost) ? $_rbt_selpost : '';
	$_rbt_seltax   = !empty($_rbt_seltax) ? $_rbt_seltax : '';
	$_rbt_taxterms = !empty($_rbt_taxterms) ? unserialize($_rbt_taxterms) : array();
	
	$args = array('public' => true);
	$output   = 'names'; 
	$operator = 'and'; 
	$inner_Html ='';
	
	$taxonomies = get_taxonomies( $args, $output, $operator ); 
	if ( $taxonomies ) {
		foreach ( $taxonomies  as $taxonomy ) {
			if(is_taxonomy_hierarchical( $taxonomy ) ){
				$taxObject = get_taxonomy($taxonomy);
				$postTypesArray[] = $taxObject->object_type[0];
			}
		}
	}
	$uniquePtypes = array_unique($postTypesArray);
	
	$post_ddown  = '<select name="_rbt_selpost" id="rbt_selpost"><option value="">Select</option>';
	foreach($uniquePtypes as $ptype){
		$post_ddown .= '<option '.selected($_rbt_selpost, $ptype, 0).' value='.$ptype.'>'.ucwords($ptype).'</option>';
	}
	$post_ddown .= '<select>';
	
	if(!empty($_rbt_selpost))
	{
		$taxonomy_obj = get_object_taxonomies( $_rbt_selpost );
		$taxonomy_Arr = (array) $taxonomy_obj;
		$taxo_ddown   = '<select name="_rbt_seltax" id="rbt_seltax"><option value="">Select</option>';
		
		foreach ( $taxonomy_Arr as $term ) { 
			if(is_taxonomy_hierarchical( $term ) ){
				$taxo_ddown .= '<option '.selected($_rbt_seltax, $term, 0).' value="' . $term . '" >' . ucwords($term) . '</option>'; 
			}
		} 
		
		$taxo_ddown .= '<select>';
		
	}else{
		$taxo_ddown  = '<select name="_rbt_seltax" id="rbt_seltax"><option value="">Select</option></select>';
	}
	
	if(!empty($_rbt_seltax))
	{
		$taxonomy  = $_rbt_seltax;
        $taxterms  = get_terms( $taxonomy, 'orderby=count&offset=1&hide_empty=0&fields=all');
		
		foreach ( $taxterms as $term ) { 
		
			if( in_array( $term->term_id, $_rbt_taxterms) ){ 
				$checked = 'checked="checked"';
			}else{
				$checked = '';
			}
		
			$inner_Html .= '<label><input type="checkbox" '.$checked. ' name="_rbt_taxterms[]" value="' . $term->term_id . '" />' . ucwords($term->name) . '</label>'; 
		} 
		
		$terms_html  = '<div id="rbt_selterms">'.$inner_Html.'</div>';
		
	}else{
		$terms_html  = '<div id="rbt_selterms"></div>';
	}
	
	// Add Ajax Loader
	echo '<div class="rbt_loader"></div>';

	// Select Post Type Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Select Post Type',$post_ddown);
	
	// Select Category/Taxonomy Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Select Category / Taxonomy',$taxo_ddown);
	
	// Choose Category/Taxonomy Items
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Select Category / Taxonomy Terms',$terms_html);

	// Create Security Nonce Data
	echo '<input type="hidden" id="rbtstring" value="'.wp_create_nonce( 'rbt-security-data' ).'" />';
}

// Create Meta Fields Function
function rbt_settings_meta_fields( $post ) 
{
	wp_nonce_field( plugin_basename( __FILE__ ), 'rbt_noncename' );
	$_rbt_st_dcol = get_post_meta( $post->ID, '_rbt_st_dcol', true );
	$_rbt_st_tcol = get_post_meta( $post->ID, '_rbt_st_tcol', true );
	$_rbt_st_pcol = get_post_meta( $post->ID, '_rbt_st_pcol', true );
	$_rbt_st_size = get_post_meta( $post->ID, '_rbt_st_size', true );
	
	// Sanitiz the meta fields
	$_rbt_st_dcol = !empty($_rbt_st_dcol) ? $_rbt_st_dcol : '';
	$_rbt_st_tcol = !empty($_rbt_st_tcol) ? $_rbt_st_tcol : '';
	$_rbt_st_pcol = !empty($_rbt_st_pcol) ? $_rbt_st_pcol : '';
	$_rbt_st_size = !empty($_rbt_st_size) ? $_rbt_st_size : '';
	
	$column_desk_dd = '<select name="_rbt_st_dcol">
		<option '.selected($_rbt_st_dcol, 'md12', 0).' value="md12">1 Column</option>
		<option '.selected($_rbt_st_dcol, 'md6', 0).' value="md6">2 Columns</option>
		<option '.selected($_rbt_st_dcol, 'md4', 0).' value="md4">3 Columns</option>
		<option '.selected($_rbt_st_dcol, 'md3', 0).' value="md3">4 Columns</option>
	</select>&nbsp;<span class="description">The number of items you want to see on the Desktop Layout.</span>';
	
	$column_tablet_dd = '<select name="_rbt_st_tcol">
		<option '.selected($_rbt_st_tcol, 'sm12', 0).' value="sm12">1 Column</option>
		<option '.selected($_rbt_st_tcol, 'sm6', 0).' value="sm6">2 Columns</option>
		<option '.selected($_rbt_st_tcol, 'sm4', 0).' value="sm4">3 Columns</option>
		<option '.selected($_rbt_st_tcol, 'sm3', 0).' value="sm3">4 Columns</option>
	</select>&nbsp;<span class="description">The number of items you want to see on the Tablet Layout.</span>';
	
	$column_phone_dd = '<select name="_rbt_st_pcol">
		<option '.selected($_rbt_st_pcol, 'xs12', 0).' value="xs12">1 Column</option>
		<option '.selected($_rbt_st_pcol, 'xs6', 0).' value="xs6">2 Columns</option>
		<option '.selected($_rbt_st_pcol, 'xs4', 0).' value="xs4">3 Columns</option>
		<option '.selected($_rbt_st_pcol, 'xs3', 0).' value="xs3">4 Columns</option>
	</select>&nbsp;<span class="description">The number of items you want to see on the Mobile Layout.</span>';
	
	$imageSizes_dd = rbt_image_sizes('_rbt_st_size',$_rbt_st_size);
	

	// Select Columns : Desktop Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Columns : Desktop',$column_desk_dd);
	
	// Select Columns : Tablet Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Columns : Tablet',$column_tablet_dd);
	
	// Select Columns : Phone Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Columns : Phone',$column_phone_dd);
	
	// Select Image Size Dropdown
	echo sprintf('<div class="rbt-item"><label class="rbt-label">%s</label><div class="rbt-field">%s</div></div>','Image Size',$imageSizes_dd);
}

// Create Meta Fields Function
function rbt_scode_meta_field( $post ) 
{
	wp_nonce_field( plugin_basename( __FILE__ ), 'rbt_noncename' );
	
	$_rbt_selpost  = get_post_meta( $post->ID, '_rbt_selpost', true );
	$_rbt_seltax   = get_post_meta( $post->ID, '_rbt_seltax', true );
	$_rbt_taxterms = get_post_meta( $post->ID, '_rbt_taxterms', true );
	$_rbt_shcode   = get_post_meta( $post->ID, '_rbt_shcode', true );
	
	// Sanitiz the meta fields
	$_rbt_selpost  = !empty($_rbt_selpost) ? $_rbt_selpost : '';
	$_rbt_seltax   = !empty($_rbt_seltax) ? $_rbt_seltax : '';
	$_rbt_taxterms = !empty($_rbt_taxterms) ? unserialize($_rbt_taxterms) : array();
	$_rbt_shcode   = !empty($_rbt_shcode) ? $_rbt_shcode : '';
	
	echo "<label>Copy shortcode after saving RBT Item.</label>";
	echo "<input type='text' name='_rbt_shcode' class='rbt-textsc' onClick='this.select();' value='$_rbt_shcode' readonly='readonly'>";
}


// Save Meta Fields Function
function rbt_save_meta_fields( $post_id ) 
{
	if ( !empty($_POST['post_type']) && 'rbt-scode' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) )
		return;
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) )
		return;
	}

	if ( ! isset( $_POST['rbt_noncename'] ) || ! wp_verify_nonce( $_POST['rbt_noncename'], plugin_basename( __FILE__ ) ) )
	return;

	$post_ID = $_POST['post_ID'];
	$_rbt_selpost  = !empty($_POST['_rbt_selpost']) ? $_POST['_rbt_selpost'] : '';
	$_rbt_seltax   = !empty($_POST['_rbt_seltax']) ? $_POST['_rbt_seltax'] : '';
	$_rbt_taxterms = !empty($_POST['_rbt_taxterms']) ? $_POST['_rbt_taxterms'] : '';
	$_rbt_st_dcol  = !empty($_POST['_rbt_st_dcol']) ? $_POST['_rbt_st_dcol'] : '';
	$_rbt_st_tcol  = !empty($_POST['_rbt_st_tcol']) ? $_POST['_rbt_st_tcol'] : '';
	$_rbt_st_pcol  = !empty($_POST['_rbt_st_pcol']) ? $_POST['_rbt_st_pcol'] : '';
	$_rbt_st_size  = !empty($_POST['_rbt_st_size']) ? $_POST['_rbt_st_size'] : '';
	
	update_post_meta($post_ID, '_rbt_selpost', $_rbt_selpost);
	update_post_meta($post_ID, '_rbt_seltax', $_rbt_seltax);
	update_post_meta($post_ID, '_rbt_st_dcol', $_rbt_st_dcol);
	update_post_meta($post_ID, '_rbt_st_tcol', $_rbt_st_tcol);
	update_post_meta($post_ID, '_rbt_st_pcol', $_rbt_st_pcol);
	update_post_meta($post_ID, '_rbt_st_size', $_rbt_st_size);
	
	if(isset($_POST['_rbt_taxterms'])){
		$data = serialize($_POST['_rbt_taxterms']);
		update_post_meta($post_ID, '_rbt_taxterms', $data);
	}else{
		update_post_meta($post_ID, '_rbt_taxterms', '');
	}
	
	if(!empty($_rbt_taxterms)){
		$_rbt_taxterms = implode(",",$_rbt_taxterms);
	}else{
		$_rbt_taxterms = '';
	}
	
	$_generate_scode = '[rbt id="'.$post_ID.'"]';
	update_post_meta($post_ID, '_rbt_shcode', $_generate_scode);
}
?>
