<?php
function rbt_shortcode_func( $atts ) {
	ob_start();
    $opts = shortcode_atts( array(
        'id' => '',
    ), $atts );
	
	$postID = $opts['id'];
	
	if(!empty($postID) && 'rbt-scode' == get_post_type($postID))
	{
		$rbt_data = get_post_meta($postID);
		
		// fetch rbt post meta data
		$_rbt_selpost  = !empty($rbt_data['_rbt_selpost'][0]) ? $rbt_data['_rbt_selpost'][0] : '';
		
		// if selected 'post type' exists
		if ( !empty($_rbt_selpost) && post_type_exists($_rbt_selpost) ) 
		{
			$_rbt_seltax   = !empty($rbt_data['_rbt_seltax'][0]) ? $rbt_data['_rbt_seltax'][0] : '';
			$_rbt_taxterms = !empty($rbt_data['_rbt_taxterms'][0]) ? unserialize($rbt_data['_rbt_taxterms'][0]) : array();
			$_rbt_st_dcol  = !empty($rbt_data['_rbt_st_dcol'][0]) ? $rbt_data['_rbt_st_dcol'][0] : '';
			$_rbt_st_tcol  = !empty($rbt_data['_rbt_st_tcol'][0]) ? $rbt_data['_rbt_st_tcol'][0] : '';
			$_rbt_st_pcol  = !empty($rbt_data['_rbt_st_pcol'][0]) ? $rbt_data['_rbt_st_pcol'][0] : '';
			$_rbt_st_size  = !empty($rbt_data['_rbt_st_size'][0]) ? $rbt_data['_rbt_st_size'][0] : '';
			
			wp_reset_query();
			
			// custom query with arguments to fetch project posts
			$rbt_posts_args = array(
				'post_type'			  => $_rbt_selpost,
				'posts_per_page'	  => '-1',
				'post_status'		  => 'publish',
				'orderby' 		  => 'date', 
				'order' 		  => 'ASC',
				'ignore_sticky_posts' => true,
				'tax_query'  => array(
					array(
						'taxonomy' => $_rbt_seltax,
						'field'    => 'id',
						'terms'    => unserialize($_rbt_taxterms),
					),
				),
			);
			$filter_posts = new WP_Query( $rbt_posts_args );
			$contentCall  = 'rbt-shortcode-'.$postID;
			?>
			<div id='<?php echo $contentCall; ?>' class='rbt-wrapper <?php echo $contentCall; ?>'><!-- .rbt-wrapper starts -->
				<!-- .rbt-filter -->
				<div class="rbt-filter">
					<ul class="filter rbtfilters">
						<li><a href="JavaScript:void(0);" data-filter="*" class="active"><?php _e('ALL ☛','rbt'); ?></a></li>
						<?php
						$filter_terms = unserialize($_rbt_taxterms);
						foreach( $filter_terms as $term_id ) 
						{
							$term      = get_term( $term_id, $_rbt_seltax );
							$term_slug = $term->slug;
							$term_name = $term->name; 
							?>
							<li><a href="JavaScript:void(0);" data-filter="<?php echo $term_slug; ?>"><?php echo $term_name; ?></a></li>
							<?php 
						} 
						?>
					</ul>
				</div>
				<div class="rbt-posts rbt-grids">
					<?php
					if ( $filter_posts->have_posts() ) :
					while ( $filter_posts->have_posts() ) : $filter_posts->the_post(); 
						$data_type  = '';
						$postID     = get_the_ID();
						$post_thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), $_rbt_st_size ); 
						$terms      = get_the_terms( $postID, $_rbt_seltax ); 
						$cat_links  = array();
						foreach ( $terms as $term ) {
							$cat_links[] = $term->slug;
						}
						foreach($cat_links as $itm){
							$data_type .= $itm.' ';
						}
						?>
						<div class="rbt-item item <?php echo $data_type; $data_type = null; ?> rbt-grid <?php echo $_rbt_st_dcol.' '.$_rbt_st_tcol.' '.$_rbt_st_pcol; ?>">
							<div class="rbt-item-meta"><?php echo get_the_date(); ?><br><?php the_time(); ?></div>					
		<?php if(isset($post_thumb[0]) && $post_thumb[0] !=""){ ?><div class="rbt-imgwrap"><img alt="<?php the_title(); ?>" src="<?php echo $post_thumb[0]; ?>" class="rbt-img"></div><?php } ?>
							
					<a class="rbt-mask" href="<?php the_permalink(); ?>"></a>
					<div class="rbt-item-title"><a class="rbt-title-mask" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
					<div class="rbt-item-description"><a class="rbt-mask" href="<?php the_permalink(); ?>"><?php the_excerpt(); ?></a></div>

						</div>
						<?php
					endwhile;
					wp_reset_postdata();
					else: 	
					_e( 'Sorry, no post items found. Kindly add.','rbt' );
					endif;
					?>
				</div>
				<script>
				jQuery(window).load( function() 
				{
					var $container = jQuery('#<?php echo $contentCall ?> .rbt-posts');
					// initialize isotope
					$container.isotope({
						filter: '*',
						animationOptions: {
							duration: 750,
							easing: 'linear',
							queue: false,
						}
					});
					// filter items when filter link is clicked
					jQuery('#<?php echo $contentCall ?> .rbtfilters a').click(function(){
						var selector = jQuery(this).attr('data-filter');
						if( selector !== '*' ) selector = selector.replace(selector, '.' + selector)
						$container.isotope({ 
							filter: selector ,
							animationOptions: {
								duration: 750,
								easing: 'linear',
								queue: false,	
							}
						});
						return false;
					});
					// set active filter items
					var $optionSets = jQuery('#<?php echo $contentCall ?> .filter'),
					$optionLinks    = $optionSets.find('a');
					$optionLinks.click(function(){
						var $this = jQuery(this);
						// don't proceed if already active
						if ( $this.hasClass('active') ) {
							return false;
						}
						var $optionSet = $this.parents('.filter');
						$optionSet.find('.active').removeClass('active');
						$this.addClass('active'); 
					});
				});	
				</script>
			</div><!-- .rbt-wrapper ends -->
			<?php
		}
		elseif(!empty($_rbt_selpost)){
			_e( 'Sorry, but '.ucwords($_rbt_selpost).' post type does not exists.','rbt' );
		}
	}
	else{
		_e( 'Sorry, RBT shortcode does not exists.','rbt' );
	}
	return ob_get_clean();
}
add_shortcode( 'rbt', 'rbt_shortcode_func' );

// Remove empty p tags for RBT shortcode
add_filter("the_content", "rbt_the_content_filter");

function rbt_the_content_filter($content) 
{
	// array of shortcode requiring the fix 
	$block = join("|",array("rbt"));
	
	// opening tag
	$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
		
	// closing tag
	$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
	
	return $rep;
}
