<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package X-CHANGE
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="stylesheet" media="screen" href="https://fontlibrary.org//face/fira-sans-condensed" type="text/css"/> 

	<?php wp_head(); ?>
</head>
	
			<header id="masthead" class="site-header">
	<div class="site-branding">
			
			<div class="col-3">		<div class="header-container"><div class="header-inner">
				
				
			
			<?php
			the_custom_logo();
			if ( is_front_page() && is_home() ) :
				?>
			
			<div class="text-header"><h1 class="site-header"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">  <?php bloginfo( 'name' ); ?>  </a></h1></div>
				<?php
			else :
				?>
				<div class="text-header"><h1 class="site-header"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1></div>
				<?php
			endif;
			$x_change_description = get_bloginfo( 'description', 'display' );
			if ( $x_change_description || is_customize_preview() ) :
				?>
				<div class="text-header"><p class="site-description"><?php echo $x_change_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
					
				<div class="date">
					
						18⇝21|2021</div>
					
					<div class="icon">
					⟳
				
						
				
					</div>
					<?php endif; ?></div>
			
			</div></div></div>
		
		
				</div><!-- .site-branding --></header>
		
<!-- #masthead -->
	<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

	
			
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'x-change' ); ?></a></div></body>


	
		<nav id="top-navigation" class="topnav" role="navigation">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-2',
					'menu_id'        => 'top-menu',
					'container_class' => 'topnav',
				)
			);
			?>
		</nav><!-- #top-navigation -->

<nav id="site-navigation" class="main-navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( '≡', 'x-change' ); ?></button>			
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
		</nav><!-- #site-navigation -->
	
	
	