<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package XX
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="col-1 entry-title"><header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
		
		<?php endif; ?>
	</header><!-- .entry-header --></div>
<div class="col-11">
	<div class="entry-meta">
				<?php
				xx_posted_on();
				xx_posted_by();
				?>
	</div><!-- .entry-meta --></div>
	<div class="col-11">	
	
	<div class="entry-content">
				<div class="post-container">
					

		
		<?php xx_post_thumbnail(); ?>
		
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'xx' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'xx' ),
				'after'  => '</div>',
			)
		);
		?>
			</div></div><!-- .entry-content --></div>

	<footer class="entry-footer">
		<?php xx_entry_footer(); ?>
		</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
