# $Id: MainLoop.rb,v 1.7 2002/12/05 21:44:56 matju Exp $
=begin

        MetaRuby
        file: Main Loop
		This is GridFlow's edition (faster and possibly less buggy)
		This should be retested properly
		And I should write unit tests for this one.

        Copyright (c) 2001,2002 by Mathieu Bouchard
        Licensed under the same license as Ruby.

=end

class MainLoop

=begin
a Message is something that can be called (activated).
it includes receiver, selector, and parameters (and block).

# the former name "Action" is now reserved for something else.
=end
class Message
	attr_accessor :receiver,:selector,:params,:block
	def initialize(receiver, selector,*params,&block)
		self.receiver = receiver
		self.selector = selector
		self.params   = params
		self.block    = block
	end
	def call
		receiver.send(selector,*params,&block)
	end
end

=begin
a MessageQueue is an array of Messages that have to be called in the order
they are received. you can #add a Message at the end of the queue, or you
can #consume the oldest Message of the Queue.
=end

class MessageQueue
	def initialize
		@queue = []
	end
	def add(x=nil)
		x ||= Message.new(Proc.new,:call)
		@queue << x
	end
	def consume
		@queue.shift.call
	end
	def empty?; @queue.empty?; end
	def length; @queue.length; end
end

=begin
a TimerQueue is a timeline of Messages that must be triggered only
after a certain point in time. note: Those Messages are now
transferred to the end of the main message queue, to allow timers
to reschedule themselves without hogging resources.
=end

class TimerQueue
# using Structs seem to cause big segfault problems but i don't know why
#	TimerEntry = Struct.new(:time,:message)
	class TimerEntry
		attr_accessor :time,:message
		def initialize(time,message) @time,@message=time,message end
	end

	def initialize(message_queue)
		@queue = []
		@message_queue = message_queue
	end

	# schedule a message or a block for execution at a specified time
	# time is a Time object.
	# delay is a Numeric object. in seconds.
	# message is a Message object.
	# block is an Object that responds to #call

	def at_time_call(a_time, a_message, &a_block)
		a_message ||= Message.new(a_block,:call)

		entry = TimerEntry.new(a_time, a_message)
		i = 0
		@queue.each {|e| e.time < entry.time or break; i+=1 }
		@queue[i,0] = [entry]
	end

	# schedule a message or a block for execution at a certain delay
	# after the current time

	def after(a_delay,a_message=nil,&block)
		at_time_call(Time.now+a_delay,a_message,&block)
	end

	def delay_no_next; 1.0; end

	def delay_until_next
		return delay_no_next if @queue.length == 0
		delay = @queue[0].time - Time.new
		delay = 0 if delay < 0
		delay
	end

	def consume
		# @queue.shift.message.call if delay_until_next == 0
		@message_queue.add @queue.shift.message if delay_until_next == 0
	end
end

=begin
a Unix Stream is what is commonly known as a file handle even though it
may be referring to a non-file like a pipe or socket. 

a Stream Observer is an object that is to be notified of certain events of
a file handle, usually incoming data.

a StreamMap is an object that keeps track of the state of various Unix
Streams and what are their associated observers.

add_stream(stream,observer,type_mask)
remove_stream(stream)

adding an already added stream automatically removes the previous registration.

stream is an IO object.

type_mask is a set of the following flags:
	StreamMap::READ
	StreamMap::WRITE
	StreamMap::EXCEPT

observer is an Object that responds to some of the following (depending on the
event-type mask):
	#ready_to_read(stream)
	#ready_to_write(stream)
	#stream_exception(stream)

=end

class StreamMap
# using Structs seem to cause big segfault problems but i don't know why
#	StreamEntry = Struct.new(:stream,:stream_observer,:type_mask)
	class StreamEntry
		attr_accessor :stream,:stream_observer,:type_mask
		def initialize(time,message)
			STDERR.puts "hello"
			@stream,@stream_observer,@type_mask=
			 stream, stream_observer, type_mask
		end
	end

	EXCEPT,WRITE,READ = 1,2,4
	Selectors = [:ready_to_read,:ready_to_write,:stream_exception]
	Flags =     [          READ,          WRITE,        EXCEPT   ]
	Nothing = [[]]*3

	def initialize
		@streams = {EXCEPT=>{},WRITE=>{},READ=>{}}
		# cache so that #select does not create too many objects
		@streamlists = {}
	end

	# why do i use #to_s again?
	def add_stream(stream,observer,type_mask)
		@streams.each {|k,v|
			next unless type_mask&k != 0
			v[stream.to_s] = StreamEntry.new(stream,observer,type_mask)
			@streamlists.remove k
		}
	end

	def remove_stream(stream)
		@streams.each {|k,v| v.remove(stream.to_s) and @streamlists.remove k }
	end

	# like IO.select, but using this object's lists, and
	# returning always a three element array.
	def select(time=nil)
		Flags.each {|f| @streamlists[f] ||= @streams[f].to_a }
		IO.select(
			@streamlists[READ],
			@streamlists[WRITE],
			@streamlists[EXCEPT],
			time) || Nothing
	end

	def make_messages(time=nil)
		lists = select(time)
		#p lists
		messages = []
		lists.each_with_index {|l,i|
			l.each{|s|
				se = @streams[Flags[i]][s.to_s]
				observer = se.stream_observer
				messages << Message.new(observer,Selectors[i],s) \
					if se.type_mask & Flags[i] > 0
			}
		}
		p messages if messages.length>0
		messages
	end
end

attr_reader :messages
attr_reader :timers
attr_reader :streams

def initialize
	@messages = MessageQueue.new
	@timers  = TimerQueue.new(@messages)
	@streams = StreamMap.new
end

def one(delay=nil)
	while @timers.delay_until_next == 0
		@timers.consume
	end
	@messages.length.times { @messages.consume }
	@streams.make_messages(delay || @timers.delay_until_next).each {|m|
		m.call
		# @messages.add m
	}
	# while not @messages.empty?; @messages.consume; end
	@messages.length.times { @messages.consume }
end

def loop
	while true; one; end
end

#--------------------------------#
end # of class MainLoop

#todo:
# algorithms for message priorities:
#  * in order (current)
#  * fully random
#  * with explicit priority level
#  * priority based on percentage of time use, frequency of use, etc.
#      (trying to be fair to different program activities)
# put examples of use that shows off all features at once
#    (tests/MainLoop.rb or samples/something...)
#  * add semi-threads (or whatever i may call them)
#  * add support for ruby-async signals.
#  * add mailboxes and such
