/**
 * Copyright (c) 2003-2008 "Onyx-VJ Team" which is comprised of:
 *
 * Daniel Hai
 * Stefano Cottafavi
 *
 * All rights reserved.
 *
 * Licensed under the CREATIVE COMMONS Attribution-Noncommercial-Share Alike 3.0
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: http://creativecommons.org/licenses/by-nc-sa/3.0/us/
 *
 * Please visit http://www.onyx-vj.com for more information
 * 
 */
package ui.states {
	
	import flash.display.*;
	import flash.events.MouseEvent;
	import flash.geom.*;
	import flash.utils.Dictionary;
	
	import onyx.constants.*;
	import onyx.controls.*;
	import onyx.core.*;
	import onyx.events.*;
	import onyx.midi.*;
	import onyx.net.*;
	import onyx.states.*;
	
	import ui.controls.*;
	import ui.layer.UILayer;
	import ui.styles.*;
	import ui.states.StateManager;

	public final class MidiLearnState extends ApplicationState {
		
		/**
		 * 	@private
		 */
		private var _control:UIControl;
		
		/**
		 * 	@private
		 */
		private var _layer:UILayer;
		
		/**
		 * 	@private
		 * 	Store the transformations for all UIControls
		 */
		private var _storeTransform:Dictionary;
		
		/**
		 * 	initialize
		 */
		override public function initialize():void {
			
			var controls:Dictionary = UIControl.controls;
			
			_storeTransform = new Dictionary(true);
			
			// Highlight all the controls
			for (var i:Object in controls) {
				var control:UIControl		= i as UIControl;
				var transform:Transform		= control.transform;
				_storeTransform[control]	= transform.colorTransform;
				transform.colorTransform	= MIDI_HIGHLIGHT;
			}
			
			STAGE.addEventListener(MouseEvent.MOUSE_DOWN, _onControlSelect, true, 9999);
		}

		/**
		 * 	@private
		 */
		private function _onControlSelect(event:MouseEvent):void {
			
			var clicked:DisplayObject = event.target as DisplayObject;

			_control = null;
			Midi.instance.removeEventListener(MidiEvent.DATA, _onMidi);

			while (clicked !== STAGE) {
				
				if (clicked is UIControl) {
					_control = clicked as UIControl;
					break;
				}
				
				clicked = clicked.parent;
				
			}
			
			// success, start the next process
			if (_control) {
				
				Midi.instance.addEventListener(MidiEvent.DATA, _onMidi);
				
				// un-highlight everything except selected control
				_unHighlight();
				
				// re-highlight the selected control
				var transform:Transform		= _control.transform;
				_storeTransform[_control]	= transform.colorTransform;
				transform.colorTransform	= MIDI_HIGHLIGHT;
							
			} else {

				// Clicked outside any control - abort learning
				StateManager.removeState(this);
				
			}
			
			// stop propagation
			event.stopPropagation();
		}
				
		/**
		 * 	Remove state
		 */
		override public function terminate():void {
			
			STAGE.removeEventListener(MouseEvent.MOUSE_DOWN, _onControlSelect, true);
			Midi.instance.removeEventListener(MidiEvent.DATA, _onMidi);
	   		_unHighlight();
	   		
	   		_storeTransform = null;
	   		
		}
		
		/**
		 * 	@private
		 */
		private function _onMidi(event:MidiEvent):void {

			Midi.registerControl(_control.control, event.midihash);
			StateManager.removeState(this);
			
			// reset and wait for another midi control
			initialize();

		}

    	/**
    	 * 	@private
    	 */
		private function _unHighlight():void {
			
			var controls:Dictionary = UIControl.controls;
			
			for (var i:Object in controls) {
				var control:UIControl	= i as UIControl;
				var color:ColorTransform	= _storeTransform[control];
				if (color) {
					var transform:Transform		= control.transform;
					transform.colorTransform	= color;
					delete _storeTransform[control];
				}
			} 
		}
		
	}
}