/**
 * Copyright (c) 2003-2008 "Onyx-VJ Team" which is comprised of:
 *
 * Daniel Hai
 * Stefano Cottafavi
 *
 * All rights reserved.
 *
 * Licensed under the CREATIVE COMMONS Attribution-Noncommercial-Share Alike 3.0
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: http://creativecommons.org/licenses/by-nc-sa/3.0/us/
 *
 * Please visit http://www.onyx-vj.com for more information
 * 
 */
package ui.window {
	 
	import flash.events.*;
	import flash.system.System;
	import flash.utils.*;
	
	import onyx.controls.*;
	import onyx.core.IDisposable;
	
	import ui.core.*;
	import ui.controls.*;
	import ui.assets.*;
	import ui.text.*;
	import module.*;
	
	import ui.states.*;
		
	/**
	 * 	The MIDI window
	 */
	public final class MidiWindow extends UIObject {
		
		/**
		 * 	@private
		 */
		private static const DEFAULT:UIOptions = new UIOptions();
		DEFAULT.width = 48;
		
		/**
		 * 	@private
		 */
		private var _learnMIDI:TextButton;
		private var _loadMIDI:TextButton;
		private var _saveMIDI:TextButton;
		
		/**
		 * 	@constructor
		 */
		public function MidiWindow():void {
				
			_learnMIDI = new TextButton(DEFAULT, 'learn');
			//_loadMIDI = new TextButton(DEFAULT, 'load');
			_saveMIDI = new TextButton(DEFAULT, 'save');
						
			addChildren(
				new StaticText('MIDI FILE'),		3,				60,
				new AssetLine(99),					3,				70,
				_learnMIDI,							3,				73,
			//	_loadMIDI,							DEFAULT.width+6,73,
				_saveMIDI,							DEFAULT.width+6,85
			);
			
			// listeners
			_learnMIDI.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			//_loadMIDI.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			_saveMIDI.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			
			
		}
		
		/**
		 * 	@private
		 */
		private function mouseDown(event:MouseEvent):void {
			switch (event.currentTarget) {
				case _learnMIDI:
					learn();
					break;
				/* case _loadMIDI:
					load();
					break; */
				case _saveMIDI:
					save();
					break;
			}
			event.stopPropagation();
		}
		
		/**
		 * 
		 */
		private function learn():void {
            StateManager.loadState(new MidiLearnState());
        }
        private function load():void {
            StateManager.loadState(new MidiLoadState());
        }
		private function save():void {
            StateManager.loadState(new MidiSaveState());
        }
        				
		/**
		 * 	Dispose
		 */
		override public function dispose():void {
			
			_learnMIDI = null;
			//_loadMIDI = null;
			_saveMIDI = null;

		}
		
	}
	
}